	clear all
	close all
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	% Lattice Wave Digital Filter 12.21
	WcT = 0.55*pi; WsT = 0.6*pi; Amax = 0.1; Amin = 65;
	N = CA_ORDER_Z(WcT, WsT, Amax, Amin)
	N = 9;	% We MUST select an odd order
	[G, Z, R_ZEROS, P, WsnewT] = CA_POLES_Z(WcT, WsT, Amax, Amin, N);	
	PLOT_PZ_Z(Z, P)
	
	% Compute the adaptor coefficients
	[Godd, Podd, Geven, Peven] = SORT_LATTICE_POLES_LP_Z(P);
	[alfa_odd, alfa_even] = CASCADE_RICHARDS_SECTIONS(Podd, Peven);
	subplot('position', [0.1 0.4 0.88 0.5]);
	wT = linspace(0, pi, 512); 
	figure(1)
	Att = PZ_2_ATT_Z(G, Z, P, wT);
	PLOT_ATT_Z(wT, Att, pi, 80)
	axis([0 pi 0 80]);
	
	alfa_even0 = alfa_even;alfa_odd0=alfa_odd;
	figure(2)
 	delta = 2^-14;
	for nn = 1:100
		alfa_odd = alfa_odd0 + delta*(rand(1,length(alfa_odd))-0.5);	
		alfa_even = alfa_even0 + delta*(rand(1,length(alfa_even))-0.5);
		[S1, S2] = LATTICE_RICHARDS_H(alfa_odd, alfa_even, wT);
		Att = MAG_2_ATT(0.5*(S2-S1));
		plot(wT, Att-min(Att),'linewidth', 1);
		hold on
	end

	zoom on
	axis([0 pi 0 80]);
	ylabel('{\itA}({\ite^j^\omega^T})  [dB]','FontName', fn,'FontSize', fs);
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);	
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};;
	xtick(ax,lab);
	grid on;
	
	%% ====================
	figure(3)
	delta = 2^-7;
	wT = linspace(0, 0.6*pi, 1000);
	for nn = 1:100
		alfa_odd = alfa_odd0 + delta*(rand(1,length(alfa_odd))-0.5);	
		alfa_even = alfa_even0 + delta*(rand(1,length(alfa_even))-0.5);
		[S1, S2] = LATTICE_RICHARDS_H(alfa_odd, alfa_even, wT);
		Att = MAG_2_ATT(0.5*(S2-S1));
		plot(wT, Att-min(Att),'linewidth', 2);
		hold on
		subplot('position', [0.1 0.4 0.88 0.5]);
	end

	zoom on
	axis([0 0.6*pi 0 0.2]);
	ylabel('{\itA}({\ite^j^\omega^T})  [dB]','FontName', fn,'FontSize', fs);
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);	
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi ];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi'};
	xtick(ax,lab);
	grid on;
	
	figure(4)
	PLOT_PZ_Z(Z, P)
	
	
